import torch


# limit interval: rectangular and triangle


class Rectangular(torch.autograd.Function):
    @staticmethod
    def forward(ctx, input_, slope):
        ctx.save_for_backward(input_)
        ctx.slope = slope
        out = (input_ > 0).float()
        return out

    @staticmethod
    def backward(ctx, grad_output):
        (input_,) = ctx.saved_tensors
        flag = abs(input_) <= (1 / ctx.slope)
        grad = grad_output * ctx.slope * flag / 2
        return grad, None


def rectangular(slope=1.0):
    def inner(x):
        return Rectangular.apply(x, slope)

    return inner


class Triangle(torch.autograd.Function):
    @staticmethod
    def forward(ctx, input_, slope):
        ctx.save_for_backward(input_)
        ctx.slope = slope
        out = (input_ > 0).float()
        return out

    @staticmethod
    def backward(ctx, grad_output):
        (input_,) = ctx.saved_tensors
        flag = abs(input_) <= (1 / ctx.slope)
        grad = grad_output * flag * ctx.slope * (1 - abs(input_) * ctx.slope)
        return grad, None


def triangle(slope=1.0):
    def inner(x):
        return Triangle.apply(x, slope)

    return inner
    
class Atan(torch.autograd.Function):
    @staticmethod
    def forward(ctx, input_, slope):
        ctx.save_for_backward(input_)
        ctx.slope = slope
        out = (input_ > 0).float()
        return out

    @staticmethod
    def backward(ctx, grad_output):
        (input_,) = ctx.saved_tensors
        slope = ctx.slope
        grad = slope / (1 + (math.pi * slope * input_) ** 2) * grad_output
        return grad, None


def actan(slope=1.0):
    def inner(x):
        return Atan.apply(x, slope)

    return inner
